--# HexRenderer2D
HexRenderer2D = class()

function HexRenderer2D:init(board, size)
    self.board = board
    self.size = size or 40
    self.origin = vec2(WIDTH/2, HEIGHT/2)
    self._fillMesh = mesh()
    self._fillMesh:resize(18)
end

-- axial -> pixel (flat top)
function HexRenderer2D:axialToPixel(q,r)
    local s = self.size
    local x = s * (3/2 * q)
    local y = s * (math.sqrt(3) * (r + q/2))
    return self.origin + vec2(x,y)
end

function HexRenderer2D:update()
    -- draw playable hexes
    local plays = self.board:playableHexes()
    for _,h in ipairs(plays) do
        local p = self:axialToPixel(h.q, h.r)
        self:updatePlayable(p)
    end
    -- draw placed tiles
    for _,t in ipairs(self.board:allHexCellsAsFlatList()) do
        local p = self:axialToPixel(t.q, t.r)
        self:updateHexCell(p, t.tile)
    end
end

function HexRenderer2D:updateHexCell(hexCenter, tile)
    local r = self.size
    local pts = {}
    
    for i=0,5 do
        local a = math.rad(-60*i + 120)
        pts[i+1] = hexCenter + vec2(
        r*math.cos(a),
        r*math.sin(a)
        )
    end
    
        local m = self._fillMesh
    
    local k=1
    for i=1,6 do
        local a = pts[i]
        local b = pts[i%6+1]
        
        m:vertex(k,hexCenter); m:color(k,200,200,255); k=k+1
        m:vertex(k,a);      m:color(k,200,200,255); k=k+1
        m:vertex(k,b);      m:color(k,200,200,255); k=k+1
    end
    
    noStroke()
    m:draw()
    
    strokeWidth(self.size * 0.25)  -- thick, obvious
    
    local inset = (self.size * 0.25) * 0.7  -- half stroke
    
    for i=1,6 do
        local a = pts[i]
        local b = pts[i%6+1]
        
        -- move edge inward
        local mid = (a + b) * 0.5
        local dir = (hexCenter - mid)
        dir = dir:normalize() * inset
        
        -- inward shift
        local a2 = a + dir
        local b2 = b + dir
        
        -- shorten ends
        local edgeDir = (b2 - a2)
        edgeDir = edgeDir:normalize()
        
        local trim = inset + 2 -- same amount feels right visually
        
        a2 = a2 + edgeDir * trim
        b2 = b2 - edgeDir * trim
        
        stroke(0)
        strokeWidth(2)
        
        if tile then
            local sideName = tile.sides[i]
            stroke(EDGE_COLORS[sideName])
            strokeWidth(self.size * 0.35)
        end
        
        line(a2.x, a2.y, b2.x, b2.y)
    end
end

function HexRenderer2D:updatePlayable(center)
    local r = self.size
    local pts = {}
    
    for i=0,5 do
        local a = math.rad(-60*i + 120)
        pts[i+1] = center + vec2(
        r*math.cos(a),
        r*math.sin(a)
        )
    end
    
    stroke(255,200,80)
    strokeWidth(3)
    noFill()
    
    for i=1,6 do
        local a = pts[i]
        local b = pts[i%6+1]
        line(a.x,a.y,b.x,b.y)
    end
end